<?php
/**
 * Plugin Name:       Comments Disable & Spam Protection
 * Plugin URI:        https://skillsurface.com/comments-spam-protect-wordpress-plugin
 * Description:       Disable comments globally on Posts, Pages, Media, and WooCommerce Products to prevent spam and clean up your WordPress site.
 * Version:           1.2
 * Author:            Skill Surface
 * Author URI:        https://skillsurface.com
 * License:           GPL-3.0
 * License URI:       https://opensource.org/licenses/GPL-3.0
 * Text Domain:       comments-spam-protect
 * Domain Path:       /languages
 * Tags:              Comments Disable, Spam Protection, website security plugin, disable comments, woocommerce comments
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Define plugin constants
define( 'CSP_VERSION', '1.2' );
define( 'CSP_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'CSP_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require_once CSP_PLUGIN_DIR . 'includes/class-csp-core-functions.php';

/**
 * The class responsible for defining all actions that occur in the admin area.
 */
require_once CSP_PLUGIN_DIR . 'admin/class-csp-admin-settings.php';


/**
 * Begins execution of the plugin.
 */
function run_csp_plugin() {
    $core = new CSP_Core_Functions();
    $admin = new CSP_Admin_Settings();
}
run_csp_plugin();


/**
 * Load plugin textdomain for translation.
 */
function csp_load_textdomain() {
    load_plugin_textdomain(
        'comments-spam-protect',
        false,
        dirname( plugin_basename( __FILE__ ) ) . '/languages/'
    );
}
add_action( 'plugins_loaded', 'csp_load_textdomain' );
