<?php
/**
 * Fired when the user deletes the Comments Disable & Spam Protection plugin.
 *
 * This file provides a clean uninstallation process by removing all plugin-specific
 * options from the WordPress database.
 *
 * @link       https://skillsurface.com
 * @since      1.2
 * @package    Comments_Spam_Protect
 */

// If uninstall is not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Single site uninstall
if ( ! is_multisite() ) {
    delete_option( 'csp_options' );
} 
// Multisite uninstall
else {
    // For site options in multisite
    delete_site_option( 'csp_options' );
}